import Head from "next/head";

export default function BaseLayout({
  title,
  description,
  children,
}: {
  title?: string;
  description?: string;
  children: React.ReactNode;
}) {
  return (
    <>
      <Head>
        <title key="title">{`${title ? title + " | " : ""}Precheck`}</title>
        <meta
          name="description"
          key="description"
          content={
            description ||
            "Precheck - added Discord server security & moderation."
          }
        />
        <meta property="og:site_name" key="og:site_name" content="precheckbot.com" />
        <meta property="og:image" key="og:site_name" content="/logo.png" />
      </Head>

      {children}
    </>
  );
}
