import {
  Accordion,
  AccordionContent,
  AccordionItem,
  AccordionTrigger,
} from "@/components/ui/accordion";
import env from "@/lib/env/client";

interface FAQProps {
  question: string;
  answer: string;
  value: string;
}

const FAQList: FAQProps[] = [
  {
    question: "Is Precheck free to use?",
    answer: "Yeah.",
    value: "item-1",
  },
  {
    question: "Can I customize the name and avatar of my Discord bot?",
    answer:
      "Nah.",
    value: "item-2",
  },
  {
    question: "Does Precheck support slash commands and other Discord features?",
    answer:
      "Yeah.",
    value: "item-3",
  },
  {
    question: "How many servers can I add my bot to?",
    answer:
      "Unlimited.",
    value: "item-4",
  },
];

export default function HomeFAQSection() {
  return (
    <section id="faq" className="container py-24 sm:py-32">
      <h2 className="text-3xl md:text-4xl font-bold mb-4">
        Frequently Asked{" "}
        <span className="bg-gradient-to-b from-primary/60 to-primary text-transparent bg-clip-text">
          Questions
        </span>
      </h2>

      <Accordion type="single" collapsible className="w-full AccordionRoot">
        {FAQList.map(({ question, answer, value }: FAQProps) => (
          <AccordionItem key={value} value={value}>
            <AccordionTrigger className="text-left">
              {question}
            </AccordionTrigger>

            <AccordionContent>{answer}</AccordionContent>
          </AccordionItem>
        ))}
      </Accordion>

      <h3 className="font-medium mt-4">
        Still have questions?{" "}
        <a
          rel="noreferrer noopener"
          href={env.NEXT_PUBLIC_DISCORD_LINK}
          target="_blank"
          className="text-primary transition-all border-primary hover:border-b-2"
        >
          Join the Discord server
        </a>
      </h3>
    </section>
  );
}
