import { buttonVariants, Button } from "@/components/ui/button";
import { CodeIcon } from "lucide-react";
import env from "@/lib/env/client";
import Link from "next/link";

export default function HomeHeroSection() {
  return (
    <section className="container grid lg:grid-cols-2 place-items-center py-20 md:py-32 gap-10">
      <div className="text-center lg:text-start space-y-6">
        <main className="text-5xl md:text-6xl font-bold">
          <h2 className="inline">
            Secure{" "}
            <span className="inline bg-gradient-to-r from-[#58d1f2] to-[#5865F2] text-transparent bg-clip-text">
              your server
            </span>
          </h2>{" "}
          with{" "}
          <h1 className="inline">
            <span className="inline bg-gradient-to-r from-[#f9ad15] to-primary text-transparent bg-clip-text">
              Precheck
            </span>
          </h1>
        </main>

        <p className="text-xl text-muted-foreground md:w-10/12 mx-auto lg:mx-0">
        Precheck is a Discord bot offering powerful security and moderation tools to protect your server and keep your community safe.
        </p>

        <div className="space-y-4 md:space-y-0 md:space-x-4">
          <Button className="w-full md:w-1/3" asChild>
            <Link href="https://discord.com/oauth2/authorize?client_id=1366133898563813436&permissions=8&integration_type=0&scope=bot" target="_blank">Invite Bot</Link>
          </Button>

          <a
            rel="noreferrer noopener"
            href="https://discord.com/invite/Q264RBxyYz"
            target="_blank"
            className={`w-full md:w-1/3 ${buttonVariants({
              variant: "outline",
            })}`}
          >
            Discord Server
          </a>
        </div>
      </div>

      {/* Hero cards sections */}
      {/*<div className="z-10">
        <HomeHeroCards />
      </div>*/}

      {/* Shadow effect */}
      <div className="shadow"></div>
    </section>
  );
}
