import * as React from "react";
import Link from "next/link";
import logo from "@/assets/logo/orange@1024.png";
import env from "@/lib/env/client";

import { cn } from "@/lib/utils";
import {
  NavigationMenu,
  NavigationMenuContent,
  NavigationMenuItem,
  NavigationMenuLink,
  NavigationMenuList,
  NavigationMenuTrigger,
  navigationMenuTriggerStyle,
} from "@/components/ui/navigation-menu";
import { PlusCircleIcon } from "lucide-react";

export default function HomeNavbarMenu() {
  return (
    <NavigationMenu>
      <NavigationMenuList>
        <NavigationMenuItem>
          <NavigationMenuTrigger>
            <img
              src={logo.src}
              className="h-6 w-6 mr-2 hidden sm:block"
              alt=""
            />
            Precheck
          </NavigationMenuTrigger>
          <NavigationMenuContent>
            <ul className="grid gap-3 p-4 w-[80dvw] md:w-[400px] lg:w-[500px] lg:grid-cols-[.75fr_1fr]">
              <li className="row-span-3">
                <Link href="/" legacyBehavior passHref>
                  <NavigationMenuLink asChild>
                    <div
                      role="button"
                      className="flex h-full w-full select-none flex-col justify-end rounded-md bg-gradient-to-b from-muted/50 to-muted p-6 no-underline outline-none focus:shadow-md"
                    >
                      <img src={logo.src} className="h-10 w-10" alt="" />
                      <div className="my-2 text-lg font-medium">Precheck</div>
                      <p className="text-sm leading-tight text-muted-foreground">
                        Discord protection made easy.
                      </p>
                    </div>
                  </NavigationMenuLink>
                </Link>
              </li>
              <ListItem href="/#features" title="Features">
                Learn about the features of Precheck and how to use them.
              </ListItem>
              <ListItem href="https://discord.com/invite/Q264RBxyYz" target="_blank" title="Discord Server">
                If you want to stay in the loop, join the Discord server.
              </ListItem>
              <ListItem href="/#faq" title="Frequently Asked Questions">
                Get answers to common questions about Precheck.
              </ListItem>
            </ul>
          </NavigationMenuContent>
        </NavigationMenuItem>
        <NavigationMenuItem className="hidden sm:block">
          <NavigationMenuLink
            href="https://discord.com/oauth2/authorize?client_id=1366133898563813436&permissions=8&integration_type=0&scope=bot"
            target="_blank"
            className={navigationMenuTriggerStyle()}
          >
            Invite Bot
          </NavigationMenuLink>
        </NavigationMenuItem>
      </NavigationMenuList>
    </NavigationMenu>
  );
}

const ListItem = ({
  className,
  title,
  children,
  ...props
}: React.ComponentPropsWithoutRef<typeof Link>) => {
  return (
    <li>
      <Link {...props} passHref>
        <NavigationMenuLink asChild>
          <div
            className={cn(
              "cursor-pointer block select-none space-y-1 rounded-md p-3 leading-none no-underline outline-none transition-colors hover:bg-accent hover:text-accent-foreground focus:bg-accent focus:text-accent-foreground",
              className
            )}
          >
            <div className="text-sm font-medium leading-none">{title}</div>
            <p className="line-clamp-2 text-sm leading-snug text-muted-foreground">
              {children}
            </p>
          </div>
        </NavigationMenuLink>
      </Link>
    </li>
  );
};
ListItem.displayName = "ListItem";
