import "@/styles/globals.css";
import "@/styles/shadow.css";
import type { AppProps } from "next/app";
import { Inter as FontSans } from "next/font/google";
import { Toaster } from "@/components/ui/sonner";
import { ThemeProvider } from "next-themes";
import { TooltipProvider } from "@/components/ui/tooltip";
import { QueryClientProvider } from "@tanstack/react-query";
import { SpeedInsights } from "@vercel/speed-insights/next";
import { Analytics } from "@vercel/analytics/react";

const fontSans = FontSans({
  subsets: ["latin"],
  variable: "--font-sans",
});

export default function App({ Component, pageProps }: AppProps) {
  return (
    <>
      <style jsx global>{`
        html {
          font-family: ${fontSans.style.fontFamily};
        }
      `}</style>
        <ThemeProvider attribute="class">
          <TooltipProvider delayDuration={200}>
            <Component {...pageProps} />
            <Toaster position="top-right" richColors={true} />

            <SpeedInsights />
            <Analytics />
          </TooltipProvider>
        </ThemeProvider>
    </>
  );
}
